﻿using System;
using System.Collections.Generic;
using Curse.Aerospike;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    [TableDefinition(TableName = "GroupPollSettings", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.HomeRegion)]
    public class GroupPollSettings : BaseTable<GroupPollSettings>, IModelRegion
    {
        [Column("GroupID",KeyOrdinal = 1)]
        public Guid GroupID { get; set; }

        [Column("MultiSelect")]
        public bool AllowMultipleSelections { get; set; }

        [Column("DisplayType")]
        public GroupPollDisplayType DisplayType { get; set; }

        [Column("RequiredRoles")]
        public HashSet<int> RequiredRoles { get; set; }

        [Column("RegionID")]
        public int RegionID { get; set; }

        [Column("IsPublic")]
        public bool IsPublic { get; set; }

        [Column("AllowRevotes")]
        public bool AllowRevotes { get; set; }

        public GroupPollDuplicateMode DuplicateMode { get; set; }

        public GroupPollSettingsNotification ToNotification()
        {
            return new GroupPollSettingsNotification
            {
                GroupID = GroupID,
                AllowMultipleSelections = AllowMultipleSelections,
                DisplayType = DisplayType,
                RequiredRoles = RequiredRoles,
                IsPublic = IsPublic,
                AllowRevotes = AllowRevotes,
                DuplicateMode = DuplicateMode
            };
        }
    }
}
