﻿using System.Collections.Generic;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    internal class GroupRoleTemplate
    {
        public GroupRoleTemplate(int vanityColor, GroupPermissions permissions)
        {
            DefaultPermissions = permissions;
            DefaultVanityColor = vanityColor;
        }
        public GroupPermissions DefaultPermissions { get; set; }
        public int DefaultVanityColor { get; set; }

        internal static GroupRoleTemplate GetDefaultGuestPermissionByGroupType(GroupType type)
        {
            return GuestDefaultsByType[type];
        }


        internal static readonly GroupRoleTemplate NormalGuest = new GroupRoleTemplate(0, GroupPermissions.Access
                                                                                          | GroupPermissions.ChatSendMessages
                                                                                          | GroupPermissions.ChatUploadPhotos
                                                                                          | GroupPermissions.ChatEmbedLinks
                                                                                          | GroupPermissions.ChatAttachFiles
                                                                                          | GroupPermissions.ChatMentionUsers
                                                                                          | GroupPermissions.VoiceSpeak
                                                                                          | GroupPermissions.InviteUsers);

        internal static readonly GroupRoleTemplate LargeGuest = new GroupRoleTemplate(0, GroupPermissions.Access
                                                                                         | GroupPermissions.ChatSendMessages
                                                                                         | GroupPermissions.ChatUploadPhotos
                                                                                         | GroupPermissions.ChatEmbedLinks
                                                                                         | GroupPermissions.ChatMentionUsers
                                                                                         | GroupPermissions.SendPrivateMessage
                                                                                         | GroupPermissions.VoiceSpeak);


        internal static readonly GroupRoleTemplate Subscriber = new GroupRoleTemplate(0, GroupPermissions.Access
                                                                                         | GroupPermissions.ChatSendMessages
                                                                                         | GroupPermissions.ChatUploadPhotos
                                                                                         | GroupPermissions.ChatEmbedLinks
                                                                                         | GroupPermissions.ChatAttachFiles
                                                                                         | GroupPermissions.ChatMentionUsers
                                                                                         | GroupPermissions.ChatBypassChatThrottle
                                                                                         | GroupPermissions.InviteUsers
                                                                                         | GroupPermissions.VoiceSpeak);

        internal static readonly GroupRoleTemplate Moderator = new GroupRoleTemplate(4, GroupPermissions.Access
                                                                                        | GroupPermissions.ChatSendMessages
                                                                                        | GroupPermissions.ChatUploadPhotos
                                                                                        | GroupPermissions.ChatEmbedLinks
                                                                                        | GroupPermissions.ChatMentionUsers
                                                                                        | GroupPermissions.ChatAttachFiles
                                                                                        | GroupPermissions.ChatBypassChatThrottle
                                                                                        | GroupPermissions.ChatModerateMessages
                                                                                        | GroupPermissions.SendPrivateMessage
                                                                                        | GroupPermissions.VoiceSpeak
                                                                                        | GroupPermissions.VoiceChangeSettings
                                                                                        | GroupPermissions.VoiceDeafenUser
                                                                                        | GroupPermissions.VoiceMoveUser
                                                                                        | GroupPermissions.VoiceKickUser
                                                                                        | GroupPermissions.InviteUsers);

        internal static readonly GroupRoleTemplate GuildMaster = new GroupRoleTemplate(4, GroupPermissions.All);

        internal static readonly GroupRoleTemplate GuildMember = new GroupRoleTemplate(0, GroupPermissions.Access
                                                                                          | GroupPermissions.SendPrivateMessage
                                                                                          | GroupPermissions.InviteUsers
                                                                                          | GroupPermissions.ChatBypassChatThrottle
                                                                                          | GroupPermissions.ChatSendMessages
                                                                                          | GroupPermissions.ChatMentionUsers
                                                                                          | GroupPermissions.ChatMentionEveryone
                                                                                          | GroupPermissions.ChatEmbedLinks
                                                                                          | GroupPermissions.ChatAttachFiles
                                                                                          | GroupPermissions.ChatUploadPhotos
                                                                                          | GroupPermissions.VoiceSpeak);

        internal static readonly GroupRoleTemplate Owner = new GroupRoleTemplate(3, GroupPermissions.All);


        internal static readonly Dictionary<GroupType, GroupRoleTemplate> GuestDefaultsByType = new Dictionary<GroupType, GroupRoleTemplate> {
            { GroupType.Normal, NormalGuest },
            { GroupType.Large, LargeGuest }
        };
    }
}
