﻿using System;
using System.Collections.Generic;
using Curse.Aerospike;
using Curse.Extensions;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    [TableDefinition(TableName = "GroupSearchSettings", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.HomeRegion)]
    public class GroupSearchSettings : BaseTable<GroupSearchSettings>, IModelRegion
    {
        public const int MaxGames = 10;
        public const int MaxDescription = 2048;

        [Column("GroupID", KeyOrdinal = 1)]
        public Guid GroupID { get; set; }

        [Column("RegionID")]
        public int RegionID { get; set; }

        /// <summary>
        /// Whether or not this group is searchable.
        /// </summary>
        [Column("IsSearchable")]
        public bool IsSearchable { get; set; }

        /// <summary>
        /// Searchable Tags for this group
        /// </summary>
        [Column("SearchTags")]
        public HashSet<int> SearchTags { get; set; }

        /// <summary>
        /// Description of the group to be included in search results.
        /// </summary>
        [Column("Description")]
        public string Description { get; set; }

        /// <summary>
        /// Games associated with the server for search results.
        /// </summary>
        [Column("Games")]
        public HashSet<int> Games { get; set; }

        /// <summary>
        /// Whether or not this server should match all games in search results.
        /// </summary>
        [Column("MatchAllGames")]
        public bool MatchAllGames { get; set; }

        protected override void Validate()
        {
            if (GroupID == Guid.Empty)
            {
                throw new Exception("Guid cannot be empty.");
            }

            if (RegionID <= 0)
            {
                throw new Exception("RegionID cannot be 0.");
            }

            if (Games == null || Games.Count > MaxGames)
            {
                throw new Exception("RegionID cannot be 0.");
            }

            if (!Description.SafeRange(0, MaxDescription))
            {
                throw new Exception("Description has an invalid range.");
            }

            if (SearchTags == null || SearchTags.Count > Enum.GetValues(typeof (GroupSearchTag)).Length)
            {
                throw new Exception("SearchTags are null or too many.");
            }
        }
    }
}
