﻿using System;
using Curse.Friends.Data.Messaging;
using Curse.Friends.Data.Models;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    public interface IConversationContainer : IAvatarParent
    {
        string ConversationID { get; }
        bool CanAccess(int userID);
        bool CanView(int userID, out DateTime latestDate, out DateTime earliestDate);
        bool CanEditAttachment(int userID, Attachment attachment);
        bool CanEditMessage(int userID, ConversationMessage message);
        bool CanMention(int userID, ConversationMessage message);
        bool CanMentionEveryone(int userID, ConversationMessage message);
        bool CanDeleteMessage(int userID, ConversationMessage message);
        bool CanSearch(int userID, out DateTime? minSearchDate);
        void OnChatMessageChanged(ConversationMessage notification, ConversationNotificationType type);
        bool CanLikeMessage(int userID, ConversationMessage message);
        bool CanCall(int userID);
        bool CanUnlockCall(int userID);
        bool CanSendMessage(int userID);
        bool CanHide();

        ConversationType ConversationType { get; }
        void OnChatMessageLike(int userID, string username, ConversationMessage message, Like like);
        string Title { get; }
        IConversationParent GetConversationParent(int userID);       
    }
}
