﻿using System;
using System.Collections.Generic;

namespace Curse.Friends.Data
{
    public interface IConversationParent
    {
        //DateTime DateMessaged { get; set; }
        DateTime DateRead { get; set; }
        int UnreadCount { get; }
        void MarkAsRead(DateTime timestamp);
        void MarkAsUnread(DateTime timestamp, int numberMessages);
        bool ShouldSendPushNotification(User user, string messageBody, HashSet<int> mentionedUserIDs);
        void ToggleHidden(bool isHidden);
        void ToggleMuted(bool isMuted);
        

        string Title { get; }

        /// <summary>
        /// Returns the most appropriate name for a message sender (Ex: Friend Nickname -> Friend Username -> Group Member Name)
        /// </summary>        
        string GetSenderName(int senderID, string fallback);
    }
}