using System;
using Curse.Aerospike;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    public enum ServiceHostStatus
    {
        Offline,
        Online,
        Updating,
        FailingOver,
        Unhealthy
    }

    public interface IServiceHost
    {
        IndexMode IndexMode { get; set; }

        ServiceHostStatus Status { get; set; }

        HostEnvironment Environment { get; set; }

        DateTime DateUpdated { get; set; }

        string MachineName { get; set; }

        string InternalIPAddress { get; set; }

        DateTime DateCreated { get; set; }

        DateTime DateOnline { get; set; }

        DateTime? DateUnhealthy { get; set; }

        DateTime? DateOffline { get; set; }

        bool IsCleaning { get; set; }

        int Version { get; set; }

        int CurrentVersion { get; }
    }
}