﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Friends.Data
{
    public interface IUserIdentity
    {
        int UserID { get; }
        string Username { get; }
        string DisplayName { get; }
        string Nickname { get; }
    }

    public static class IUserIdentityExtensions
    {
        public static bool HasDifferentDisplayName(this IUserIdentity identity)
        {
            return !string.IsNullOrEmpty(identity.DisplayName) && !identity.DisplayName.Equals(identity.Username, StringComparison.InvariantCultureIgnoreCase);
        }

        public static bool HasDifferentNickname(this IUserIdentity identity)
        {
            return !string.IsNullOrEmpty(identity.Nickname) && !identity.Nickname.Equals(identity.GetResolvedName(), StringComparison.InvariantCultureIgnoreCase); 
        }

        public static string GetResolvedName(this IUserIdentity identity)
        {
            return string.IsNullOrEmpty(identity.DisplayName) ? identity.Username : identity.DisplayName; 
        }

        public static string GetTitleName(this IUserIdentity identity)
        {
            if (!string.IsNullOrWhiteSpace(identity.Nickname) && identity.HasDifferentNickname())
            {
                return identity.Nickname;
            }

            if (identity.HasDifferentDisplayName())
            {
                return identity.DisplayName + " (" + identity.Username + ")";
            }

            return identity.GetResolvedName();
        }

        public static object GetLogData(this IUserIdentity identity)
        {
            return new
            {
                identity.UserID,
                identity.Username,
                identity.DisplayName,
                identity.Nickname,                
                ResolvedName = identity.GetResolvedName(),
                TitleName = identity.GetTitleName()
            };
        }
    }
}
