﻿using Curse.Aerospike;

namespace Curse.Friends.Data
{
    public enum KinesisAccountSource
    {
        Curse,
        Twitch
    }

    [TableDefinition(TableName = "KinesisShardIterator", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class KinesisShardIterator : BaseTable<KinesisShardIterator>, IHostable
    {
        [Column("AcctSource", KeyOrdinal = 1)]
        public KinesisAccountSource AccountSource { get; set; }

        [Column("StreamName", KeyOrdinal = 2)]
        public string StreamName { get; set; }

        [Column("ShardID", KeyOrdinal = 3)]
        public string ShardID { get; set; }

        [Column("SequenceNum")]
        public string LastSequenceNumber { get; set; }

        [Column("MachineName", IsIndexed = true)]
        public string MachineName { get; set; }

        [Column("RegionID", IsIndexed = true)]
        public int RegionID { get; set; }        

        public static KinesisShardIterator GetBySourceNameAndShard(KinesisAccountSource source, string name, string shard)
        {
            return GetLocal(source, name, shard);
        }

        public object[] KeyObjects
        {
            get { return new object[] { AccountSource, StreamName, ShardID }; }
        }

        public bool IsHostable
        {
            get
            {
                return true;
            }
        }


        public string DisplayName
        {
            get { return StreamName + ":" + ShardID; }
        }
    }
}
