﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using Curse.Aerospike;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    
    [Serializable]
    [DataContract]
    [Obsolete]
    public class LegacyGroupMember : ILargeListElement, IEqualityComparer<LegacyGroupMember>
    {
        [DataMember]
        public int UserID { get; set; }

        [DataMember]
        public string Username { get; set; }

        [DataMember]
        public int RegionID { get; set; }

        [DataMember]
        public LegacyGroupRole Role { get; set; }

        [DataMember]
        public Guid CurrentGroupID { get; set; }

        [DataMember]
        public DateTime DateJoined { get; set; }

        [DataMember]
        public DateTime DateLastActive { get; set; }

        [DataMember]
        public string InviteCode { get; set; }                

        public void Hydrate(Dictionary<object, object> values)
        {
            UserID = Convert.ToInt32(values["userID"]);
            Username = (string)values["username"];
            RegionID = Convert.ToInt32(values["regionID"]);
            Role = (LegacyGroupRole)Convert.ToInt32(values["role"]);
            if (values.ContainsKey("currentGroup"))
            {
                CurrentGroupID = (Guid) values["currentGroup"];
            }

            if (values.ContainsKey("dateJoined"))
            {
                DateJoined = (DateTime)values["dateJoined"];
            }

            if (values.ContainsKey("dateLastActive"))
            {
                DateLastActive = (DateTime)values["dateLastActive"];
            }

            if (values.ContainsKey("inviteCode"))
            {
                InviteCode = (string)values["inviteCode"];
            }
        }

        public Dictionary<object, object> ToHash()
        {
            var dict = new Dictionary<object, object>
            {                
                { "userID", UserID },
                { "username", Username },
                { "regionID", RegionID },
                { "role", (int)Role },
                { "currentGroup", CurrentGroupID },
                { "dateJoined", DateJoined },
                { "dateLastActive", DateLastActive },
                { "inviteCode", InviteCode },
            };

            return dict;
        }

        public long GetKey()
        {
            return UserID;
        }

        public bool Equals(LegacyGroupMember x, LegacyGroupMember y)
        {
            if (x == null && y == null)
            {
                return false;
            }

            if (x == null && y != null)
            {
                return false;
            }

            if (y == null && x != null)
            {
                return false;
            }

            return y.UserID == x.UserID;
        }

        public int GetHashCode(LegacyGroupMember obj)
        {
            return obj.UserID;
        }
    }
}
