﻿using System;
using Curse.Aerospike;

namespace Curse.Friends.Data
{
    public enum LikeType
    {        
        ConversationMessage = 1
    }

    [TableDefinition(TableName = "Like", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class Like : BaseTable<Like>
    {
        [Column("EntityType", KeyOrdinal = 1)]
        public int EntityType
        {
            get;
            set;
        }
    
        [Column("EntityID", KeyOrdinal = 2)]
        public string EntityID
        {
            get;
            set;
        }

        [Column("UserID", KeyOrdinal = 3)]
        public int UserID
        {
            get;
            set;
        }

        [Column("Unlike")]
        public bool Unlike
        {
            get;
            set;
        }

        protected override void Validate()
        {
            if (EntityType <= 0)
            {
                throw new InvalidOperationException("EntityType must be a valid number");
            }

            if (UserID <= 0)
            {
                throw new InvalidOperationException("UserID must be a valid number");
            }

            if (string.IsNullOrWhiteSpace(EntityID))
            {
                throw new InvalidOperationException("UserID must be a valid number");
            }            
        }

        public static Like Create(LikeType entityType, string entityID, int userID)
        {
            var like = new Like
            {
                EntityType = (int)entityType,
                EntityID = entityID,
                UserID = userID
            };

            like.InsertLocal();

            return like;
        }

        public static Like GetByEntityTypeAndEntityAndUser(int entityType, string entityID, int userID)
        {
            return GetLocal(entityType, entityID, userID);
        }
    }
}
