﻿using Curse.Aerospike;
using Curse.Friends.Enums;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Friends.Data
{
    public enum NotificationHostStatus
    {
        Offline,
        Online,
        Updating,
        FailingOver,
        Unhealthy
    }

    [TableDefinition(TableName = "NotificationHost", KeySpace = "CurseVoice", ReplicationMode = ReplicationMode.None)]
    public class NotificationHost : BaseTable<NotificationHost>
    {
        
        [Column("InternalIP", KeyOrdinal = 1)]
        public string InternalIPAddress
        {
            get;
            set;
        }
        
        [Column("PublicIP")]
        public string PublicIPAddress
        {
            get;
            set;
        }
        
        [Column("MachineName")]
        public string MachineName
        {
            get;
            set;

        }

        [Column("Status")]
        public NotificationHostStatus Status
        {
            get;
            set;
        }

        [Column("DateCreated")]
        public DateTime DateCreated
        {
            get;
            set;
        }

        [Column("DateUpdated")]
        public DateTime DateUpdated
        {
            get;
            set;
        }

        [Column("DateOnline")]
        public DateTime DateOnline
        {
            get;
            set;
        }

        [Column("DateOffline")]
        public DateTime? DateOffline
        {
            get;
            set;
        }

        [Column("DateUnhealthy")]
        public DateTime? DateUnhealthy
        {
            get;
            set;
        }

        [Column("IndexMode", IsIndexed = true)]
        public IndexMode IndexMode
        {
            get;
            set;
        }

        [Column("Environment")]
        public HostEnvironment Environment
        {
            get;
            set;
        }

        [Column("Version")]
        public int Version { get; set; }

        public int CurrentVersion
        {
            get { return 2; }
        }
    }
}
