﻿using System;
using Curse.Aerospike;
using Newtonsoft.Json;

namespace Curse.Friends.Data
{
    [TableDefinition(TableName = "OAuthState", ReplicationMode = ReplicationMode.None, KeySpace = "CurseVoice")]
    public class OAuthState : BaseTable<OAuthState>
    {
        [Column("Key", KeyOrdinal = 1)]
        public string Key { get; set; }

        [Column("ClientID")]
        public string ClientID { get; set; }

        [Column("Data")]
        public string Data { get; set; }

        [Column("Date")]
        public DateTime DateCreated { get; set; }

        public static OAuthState CreateForSeed(object seed, int ttlSeconds = 0, string clientID = null)
        {
            var state = new OAuthState
            {
                Key = Guid.NewGuid().ToString("N"),
                Data = JsonConvert.SerializeObject(seed),
                DateCreated = DateTime.UtcNow,
                ClientID = clientID
            };
            state.InsertLocal(UpdateMode.Default, ttlSeconds);
            return state;
        }
    }
}
