﻿using System;
using System.Linq;
using Curse.Aerospike;
using Curse.Extensions;

namespace Curse.Friends.Data.Models
{
    public enum TempAccountStatus
    {
        Pending = 1,
        Active = 2,
        Claimed = 3,

    }

    [TableDefinition(TableName = "TempAccount", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class TempAccount : BaseTable<TempAccount>
    {
        [Column("Token", KeyOrdinal = 1)]
        public Guid Token { get; set; }

        [Column("Timestamp", IsIndexed = true)]
        public long Timestamp { get; set; }

        [Column("UserID", IsIndexed = true)]
        public int UserID { get; set; }

        [Column("Status")]
        public TempAccountStatus Status { get; set; }

        [Column("IPAddress", IsIndexed = true)]
        public string IpAddress { get; set; }
        
        public static bool CanCreate(string ipAddress, int maxAccountsPerHour)
        {
            var allAccounts = GetAllLocal(p => p.IpAddress, ipAddress);

            // Look at the number of accounts creatd in the last hour
            var oneHourAgo = DateTime.UtcNow.AddHours(-1).ToEpochMilliseconds();

            var totalAccountsCreated = allAccounts.Count(p => p.Status != TempAccountStatus.Claimed && p.Timestamp >= oneHourAgo);

            if (totalAccountsCreated >= maxAccountsPerHour)
            {
                return false;
            }

            return true;            
        }

        public static TempAccount Create(string ipAddress)
        {
            var tempAccount = new TempAccount
            {
                Token = Guid.NewGuid(),
                Timestamp = DateTime.UtcNow.ToEpochMilliseconds(),
                IpAddress = ipAddress,
                Status = TempAccountStatus.Pending
            };

            tempAccount.InsertLocal();

            return tempAccount;
        }

        public static bool IsTempAccount(int userID)
        {
            var account = GetAllLocal(p => p.UserID, userID).FirstOrDefault();
            if (account == null)
            {
                return false;
            }

            return account.Status == TempAccountStatus.Active;

        }
    }
}
