﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Aerospike;
using Curse.Extensions;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    public enum TemporaryAccessTokenStatus
    {
        Active,
        Used
    }

    [TableDefinition(TableName = "TemporaryAccessToken", KeySpace = "CurseVoice", ReplicationMode = ReplicationMode.None)]
    public class TemporaryAccessToken : BaseTable<TemporaryAccessToken>
    {
        [Column("UserID", KeyOrdinal = 1)]
        public int UserID { get; set; }

        [Column("Token")]
        public Guid Token { get; set; }

        [Column("DateExpires")]
        public DateTime DateExpires { get; set; }

        [Column("Status")]
        public TemporaryAccessTokenStatus Status { get; set; }

        public TemporaryAccessTokenContract ToNotification()
        {
            return new TemporaryAccessTokenContract
            {
                AccessToken = Token,
                DateExpires = DateExpires.ToEpochMilliseconds()
            };
        }
    }
}
