﻿using System.Collections.Generic;
using Curse.Aerospike;

namespace Curse.Friends.Data
{
    [TableDefinition(TableName = "TwitchChatBadge", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class TwitchChatBadge : BaseTable<TwitchChatBadge>
    {
        public static readonly string GlobalExternalID = "global";

        [Column("BadgeSet", KeyOrdinal = 1)]
        public string BadgeSet { get; set; }

        [Column("Version", KeyOrdinal = 2)]
        public string Version { get; set; }

        [Column("ExternalID", KeyOrdinal = 3, IsIndexed = true)]
        public string ExternalID { get; set; }

        [Column("ImageUrl")]
        public string ImageUrl { get; set; }

        [Column("Title")]
        public string Title { get; set; }

        [Column("Description")]
        public string Description { get; set; }

        [Column("IsDeleted")]
        public bool IsDeleted { get; set; }

        [Column("ClickAction")]
        public string ClickAction { get; set; }

        [Column("ClickUrl")]
        public string ClickUrl { get; set; }

        public static IReadOnlyCollection<TwitchChatBadge> GetAllGlobals()
        {
            return GetAllLocal(b => b.ExternalID, GlobalExternalID);
        }

        public static string GetAvatarEntityID(string badgeSet, string version, string externalID = null)
        {
            if (externalID != null && (badgeSet == "subscriber" || badgeSet == "bits"))
            {
                return string.Join("_", badgeSet, version, externalID);
            }

            return string.Join("_", badgeSet, version);
        }

        public string GetAvatarEntityID()
        {
            return GetAvatarEntityID(BadgeSet, Version, ExternalID);
        }


    }
}
