﻿using System.Collections.Generic;
using System.Linq;
using Curse.Aerospike;

namespace Curse.Friends.Data
{
    [TableDefinition(TableName = "TwitchEmote", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class TwitchEmote : BaseTable<TwitchEmote>
    {
        [Column("EmoteID", KeyOrdinal = 1)]
        public long EmoteID { get; set; }

        [Column("Regex")]
        public string Regex { get; set; }

        [Column("EmoteSet", IsIndexed = true)]
        public int EmoticonSet { get; set; }

        [Column("Url")]
        public string Url { get; set; }

        [Column("IsDeleted")]
        public bool IsDeleted { get; set; }

        [Column("IndexMode", IsIndexed = true)]
        public IndexMode IndexMode { get; set; }

        [Column("Width")]
        public int Width { get; set; }

        [Column("Height")]
        public int Height { get; set; }

        [Column("IsAlpha")]
        public bool IsAlphanumeric { get; set; }

        public static IReadOnlyCollection<TwitchEmote> MultiGetByIDs(IEnumerable<long> ids)
        {
            return MultiGetLocal(new HashSet<long>(ids).Select(id => new KeyInfo(id)));
        }
    }
}
