﻿using System;
using System.Collections.Generic;
using System.Linq;
using Curse.Aerospike;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data.Models
{
    [TableDefinition(TableName = "UserPrivacySettings", KeySpace = "CurseVoice-Global", ReplicationMode = ReplicationMode.Mesh)]
    public class UserPrivacySettings : BaseTable<UserPrivacySettings>
    {
        [Column("UserID", KeyOrdinal = 1)]
        public int UserID { get; set; }
       
        /// <summary>
        /// Allow users who are considered to be a stranger (not friends, not members of a server together) to send me a PM.
        /// </summary>
        [Column("BlckStrangers")]
        public bool BlockStrangerPMs { get; set; }

        [Column("FriendReq")]
        public FriendRequestPrivacy FriendRequestPrivacy { get; set; }

        [Column("Activity")]
        public ShareActivityPrivacy ShareActivityPrivacy { get; set; }

        public static UserPrivacySettings GetByUserOrDefault(int userID)
        {
            var settings = GetLocal(userID);

            if (settings != null)
            {                
                return settings;
            }

            settings = new UserPrivacySettings { UserID = userID };
            settings.InsertLocal();
            return settings;
        }

        public static Dictionary<int,UserPrivacySettings> GetDictionaryByUserIDs(HashSet<int> userIDs)
        {
            return MultiGetLocal(userIDs.Select(id => new KeyInfo(id))).ToDictionary(u => u.UserID);
        }

        public UserPrivacySettingsContract ToContract()
        {
            return new UserPrivacySettingsContract
            {
                PrivateMessagePrivacy = BlockStrangerPMs ? PrivateMessagePrivacy.FriendsOnly :  PrivateMessagePrivacy.Anyone,
                FriendRequestPrivacy = FriendRequestPrivacy,
                ShareActivityPrivacy = ShareActivityPrivacy,
            };
        }
    }
}
