﻿using System;
using Curse.Aerospike;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    [TableDefinition(TableName = "UserTracking", ReplicationMode = ReplicationMode.Mesh, KeySpace = "CurseVoice-Global")]
    public class UserTracking : BaseTable<UserTracking>
    {
        [Column("UserID", KeyOrdinal =1)]
        public int UserID { get; set; }

        [Column("PartnerUpsell")]
        public bool HasSeenPartnerUpsell { get; set; }

        public static UserTracking GetOrCreateForUser(int userID)
        {
            var tracking = GetLocal(userID);
            if (tracking != null)
            {
                return tracking;
            }

            tracking = new UserTracking
            {
                UserID = userID
            };
            tracking.InsertLocal();
            return tracking;
        }

        public static void TrackAction(int userID, UserTrackingType trackingType)
        {
            var tracking = GetOrCreateForUser(userID);

            switch (trackingType)
            {
                case UserTrackingType.PartnerServerUpsell:
                    tracking.HasSeenPartnerUpsell = true;
                    tracking.Update(t => t.HasSeenPartnerUpsell);
                    break;
            }
        }
    }
}
