﻿using System.Collections.Generic;
using Curse.Extensions;

namespace Curse.Friends.Data.Models
{
    public static class ValidationExtensions
    {
        public static void CheckRange<T>(this IReadOnlyCollection<T> value, int min, int max, string messageFormat = "Failed validation")
        {            
            if (value == null || value.Count < min || value.Count > max)
            {
                throw new DataValidationException(string.Format(messageFormat, min, max));
            }
        }

        public static void CheckRange(this string value, int min, int max, string messageFormat = "Failed validation")
        {           
            var safeLength = value.SafeLength();

            if (safeLength < min || safeLength > max)
            {
                throw new DataValidationException(string.Format(messageFormat, min, max));
            }
        }
    }
}
