﻿using Curse.CloudQueue;

namespace Curse.Friends.Data
{
    public abstract class BaseClientEndpointNotification<T> : BaseCloudQueueRoutedMessage<T> where T : class, ICloudQueueRoutedMessage
    {

        protected BaseClientEndpointNotification() { }

        public BaseClientEndpointNotification(ClientEndpoint endpoint) : base(endpoint.ServerName, endpoint.RegionID)
        {            
            ClientSessionID = endpoint.SessionID;
            ClientUserID = endpoint.UserID;
            ClientMachineKey = endpoint.MachineKey;
        }

        public string ClientMachineKey
        {
            get;
            set;
        }

        public int ClientUserID
        {
            get;
            set;
        }

        public string ClientSessionID
        {
            get;
            set;
        }
    }
}
