﻿using Curse.CloudQueue;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    public abstract class BaseExternalCommunityNotification<T> : BaseCloudQueueRoutedMessage<T> where T : class, ICloudQueueRoutedMessage
    {
        public string ExternalCommunityID { get; set; }

        public AccountType ExternalCommunityType { get; set; }

        public BaseExternalCommunityNotification()
        {
            
        } 

        public BaseExternalCommunityNotification(ExternalCommunity community)
        {
            ExternalCommunityID = community.ExternalID;
            ExternalCommunityType = community.Type;

            community.EnsureHost();

            DestinationServerName = community.MachineName;
            DestinationRegionID = community.RegionID;
        } 
    }
}
