﻿using Curse.CloudQueue;
using System;
using System.Collections.Generic;
using Aerospike.Client;
using Curse.Aerospike;
using Curse.Logging;

namespace Curse.Friends.Data.Queues
{
    public abstract class BaseGroupEndpointNotification<T> : BaseCloudQueueRoutedMessage<T> where T : class, ICloudQueueRoutedMessage
    {
        protected BaseGroupEndpointNotification() { }

        public BaseGroupEndpointNotification(Group group)
            : base(group.MachineName, group.RegionID)
        {
            if (!group.IsRootGroup)
            {
                throw new ArgumentException("Only root groups may be coordinated!");
            }
            GroupID = group.GroupID;
        }
       
        public Guid GroupID
        {
            get;
            set;
        }
    }
}
