﻿using System;
using Curse.CloudQueue;

namespace Curse.Friends.Data.Queues
{
    public abstract class BaseLockableMessage<T> : BaseCloudQueueRoutedMessage<T> where T : class, ICloudQueueRoutedMessage
    {
        public Guid RequestID { get; set; }

        public BaseLockableMessage()
        {
        }

        public BaseLockableMessage(string destinationServerName, int destinationRegionID, Guid requestID) : base(destinationServerName, destinationRegionID)
        {
            RequestID = requestID;
        }
    }
}
