﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.SocketMessages;

namespace Curse.Friends.Data.Queues
{
    public abstract class BaseMultiSessionNotifier<T> where T:Contract<T>
    {
        private readonly T _notification;
        private readonly string _serverName;
        private readonly int _regionID;
        private readonly HashSet<string> _sessionIDs;

        protected BaseMultiSessionNotifier(T notification, HashSet<string> sessionIDs, string serverName, int regionID)
        {
            _notification = notification;
            _sessionIDs = sessionIDs;
            _serverName = serverName;
            _regionID = regionID;
        }


        public void Enqueue()
        {
            MultiSessionNotifier.Create(_notification, _sessionIDs, _serverName, _regionID);
        }
    }
}
