﻿using System.Collections.Generic;
using Curse.CloudQueue;

namespace Curse.Friends.Data
{
    public abstract class BaseSessionNotification<T> : BaseCloudQueueRoutedMessage<T> where T : class, ICloudQueueRoutedMessage
    {

        protected BaseSessionNotification() { }

        public BaseSessionNotification(HashSet<string> sessionIDs, string serverName, int regionID)
            : base(serverName, regionID)
        {
            SessionIDs = sessionIDs;
        }

        public HashSet<string> SessionIDs
        {
            get;
            set;
        }
    }
}
