﻿using System;
using Curse.CloudQueue;
using Curse.SocketMessages;

namespace Curse.Friends.Data.Queues
{
    public abstract class BaseTargetedNotifier<T> where T: Contract<T>
    {
        private readonly T _notification;

        private readonly ClientEndpoint _endpoint;

        protected BaseTargetedNotifier(T notification, ClientEndpoint endpoint)
        {
            _notification = notification;
            _endpoint = endpoint;
        }

        public void Enqueue()
        {
            SingleSessionNotifier.Create(_notification, _endpoint);
        }
    }
}
