﻿using Curse.CloudQueue;

namespace Curse.Friends.Data
{
    public enum BattleNetGuildWorkerType
    {
        SyncMembers,
    }

    [CloudQueue(false)]
    [CloudQueueProcessor(4, true)]
    public class BattleNetGuildWorker : BaseCloudQueueShoveledMessage<BattleNetGuildWorker>
    {
        public BattleNetGuildWorkerType Type { get; set; }
        public ExternalGuild Guild { get; set; }

        public BattleNetGuildWorker()
        {
            
        }

        public BattleNetGuildWorker(int region) : base(region)
        {
            
        }

        public static void SyncMembers(ExternalGuild guild)
        {
            new BattleNetGuildWorker(QueueConfiguration.LocalRegionID)
            {
                Type = BattleNetGuildWorkerType.SyncMembers,
                Guild = guild
            }.Enqueue();
        }
    }
}
