﻿using System;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data.Queues
{
    /// <summary>
    ///  A comprensive call details interface used for passing around various queues
    /// </summary>
    public class CallDetails
    {        
        public string CallID { get; set; }        
        public string ConversationID { get; set; }
        public DateTime Timestamp { get; set; }        
        public string InviteCode { get; set; }        
        public string InviteUrl { get; set; }        
        public long? AutoMatchKey { get; set; }        
        public int HostID { get; set; }
        public string RegionName { get; set; }
        public int? GameID { get; set; }
        public string HostName { get; set; }
        public string IpAddress { get; set; }
        public CallType Type { get; set; }
        public int CreatorID { get; set; }        
        public string CreatorName { get; set; }
        public bool ForceJoin { get; set; }
        public CallMode Mode { get; set; }

        public CallNotification ToNotification(long accessToken, int senderID, string senderName)
        {
            return new CallNotification
            {
                CallID = CallID,
                AccessToken = accessToken,
                AutoMatchKey = AutoMatchKey,
                InviteUrl = InviteUrl,
                InviteCode = InviteCode,
                CallType = Type,
                GameID = GameID,
                CreatorName = CreatorName, 
                HostID = HostID,
                HostName = HostName,
                IpAddress = IpAddress,
                RegionName = RegionName,
                CreatorID = CreatorID,
                Timestamp = Timestamp,
                SenderID = senderID,
                SenderName = senderName,
                ConversationID = ConversationID,
                ForceJoin = ForceJoin,
                Mode = Mode
            };
        }
    }
}
