﻿using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data.Queues
{
    public class CallNotifier : BaseClientEndpointNotification<CallNotifier>
    {
        public CallNotifier() { }

        public CallNotifier(ClientEndpoint endpoint)
            : base(endpoint)
        {

        }

        public CallNotification Notification { get; set; }


        public static void Create(ClientEndpoint endpoint, CallNotification notification)
        {
            new CallTargetedNotifier(notification, endpoint).Enqueue();
        }
    }

    public class CallTargetedNotifier : BaseTargetedNotifier<CallNotification>
    {
        public CallTargetedNotifier(CallNotification notification, ClientEndpoint endpoint) : base(notification, endpoint)
        {
        }
    }
}
