﻿using Curse.CloudQueue;
using Newtonsoft.Json;

namespace Curse.Friends.Data.Queues
{
    public class CallResolver : BaseCloudQueueShoveledMessage<CallResolver>
    {
        [JsonConstructor]
        public CallResolver() { }

        protected CallResolver(int destinationRegionID)
            : base(destinationRegionID)
        {
         
        }

        public int SenderID { get; set; }
        public string SenderName { get; set; }
        public int RecipientID { get; set; }
        public CallDetails CallDetails { get; set; }

        public static void Create(int senderID, string senderName, int recipientID, CallDetails callDetails)
        {
            var region = UserRegion.GetByUserID(recipientID);

            new CallResolver(region.RegionID)
            {
                RecipientID = recipientID,
                SenderID = senderID,
                SenderName = senderName,
                CallDetails = callDetails,                
            }.Enqueue();
        }
    }
}
