﻿using Curse.CloudQueue;
using Curse.Friends.NotificationContracts;
using Newtonsoft.Json;

namespace Curse.Friends.Data.Queues
{
    public class CallRespondedResolver : BaseCloudQueueShoveledMessage<CallRespondedResolver>
    {
        [JsonConstructor]
        public CallRespondedResolver() { }

        protected CallRespondedResolver(int destinationRegionID)
            : base(destinationRegionID)
        {

        }

        public int UserID { get; set; }
        public CallRespondedNotification Notification { get; set; }

        public static void Create(int userID, CallRespondedNotification notification)
        {
            var region = UserRegion.GetByUserID(userID);

            new CallRespondedResolver(region.RegionID)
            {
                UserID = userID,
                Notification = notification,
            }.Enqueue();
        }
    }
}
