﻿using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data.Queues
{
    public class ChatMessageResponseNotifier : BaseClientEndpointNotification<ChatMessageResponseNotifier>
    {
        public ChatMessageResponseNotifier() { }

        public ChatMessageResponseNotifier(ClientEndpoint endpoint)
            : base(endpoint)
        {

        }

        public static void Create(ClientEndpoint endpoint, ConversationMessageResponse notification)
        {
            new ChatMessageResponseTargetedNotifier(notification, endpoint).Enqueue();
        }

        public ConversationMessageResponse Notification
        {
            get;
            set;
        }
    }

    public class ChatMessageResponseTargetedNotifier : BaseTargetedNotifier<ConversationMessageResponse>
    {
        public ChatMessageResponseTargetedNotifier(ConversationMessageResponse notification, ClientEndpoint endpoint) : base(notification, endpoint)
        {
        }
    }
}
