﻿using Curse.Friends.Data.Queues;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    /// <summary>
    /// Notifies a connected client that one of their friends have changed.
    /// </summary>    
    public class ConversationReadNotifier : BaseClientEndpointNotification<ConversationReadNotifier>
    {
        public ConversationReadNotifier() { }

        public ConversationReadNotifier(ClientEndpoint endpoint, ConversationReadNotification notification)
            : base(endpoint)
        {
            Notification = notification;
        }
        
        public ConversationReadNotification Notification
        {
            get;
            set;
        }

        public static void Create(ClientEndpoint endpoint, ConversationReadNotification notification)
        {
            new ConversationReadTargetedNotifier(notification,endpoint).Enqueue();
        }
    }

    public class ConversationReadTargetedNotifier : BaseTargetedNotifier<ConversationReadNotification>
    {
        public ConversationReadTargetedNotifier(ConversationReadNotification notification, ClientEndpoint endpoint) : base(notification, endpoint)
        {
        }
    }
}
