﻿using System;
using Curse.CloudQueue;

namespace Curse.Friends.Data.Queues
{
    [CloudQueue(false)]
    [CloudQueueProcessor(4, true)]
    public class ConversationReadWorker : BaseCloudQueueWorkerMessage<ConversationReadWorker>
    {
        public int UserID { get; set; }
        public string ConversationID { get; set; }        
        public string MachineKey { get; set; }
        public string MessageID { get; set; }
        public DateTime MessageTimestamp { get; set; }
        public bool IsExternal { get; set; }

        public static void Create(int userID, string conversationID, DateTime messageTimestamp, string machineKey, string messageID, bool isExternal)
        {
            if (userID <= 0)
            {
                throw new ArgumentException("Invalid user ID: " + userID);
            }

            if (string.IsNullOrEmpty(conversationID))
            {
                throw new ArgumentException("Invalid conversation ID: " + conversationID);
            }            

            new ConversationReadWorker
            {
                UserID = userID,
                ConversationID = conversationID,
                MessageTimestamp = messageTimestamp,
                MachineKey = machineKey,
                MessageID = messageID,
                IsExternal = isExternal
            }.Enqueue();
        }
    }
}
