﻿using System;
using System.Linq;
using Curse.Aerospike;
using Curse.CloudQueue;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    [CloudQueueProcessor(true)]
    public class ExternalAccountSyncResolver : BaseCloudQueueWorkerMessage<ExternalAccountSyncResolver>
    {        
        public int UserID { get; set; }

        public static void Create(int userID)
        {
            new ExternalAccountSyncResolver
            {
                UserID = userID
            }.Enqueue();
        }
    }
}
