﻿using Curse.CloudQueue;

namespace Curse.Friends.Data
{
    [CloudWorkerQueue(50000, MaxQueueBytes = 256 * 1024 * 1024)]
    public class ExternalCommunityIndexWorker : BaseCloudQueueShoveledMessage<ExternalCommunityIndexWorker>
    {
        public ExternalCommunity Community { get; set; }

        public static void Create(ExternalCommunity community)
        {
            new ExternalCommunityIndexWorker
            {
                Community = community
            }.Enqueue();
        }       
    }
}
