﻿using System.Linq;
using Curse.Aerospike;
using Curse.CloudQueue;
using Curse.Friends.Configuration;
using Curse.Friends.Data.Queues;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;
using System.Collections.Generic;

namespace Curse.Friends.Data
{
    [CloudQueueProcessor(false)]
    public class ExternalCommunityLinkChangedCoordinator : BaseGroupEndpointNotification<ExternalCommunityLinkChangedCoordinator>
    {
        public ExternalCommunityLinkChangedNotification Notification { get; set; }
        public ExternalCommunity ExternalCommunity { get; set; }

        public ExternalCommunityLinkChangedCoordinator()
        {
            
        }

        public ExternalCommunityLinkChangedCoordinator(Group group) : base(group)
        {
            
        }

        public static void Create(Group group, ExternalCommunityLinkChangeType changeType, ExternalCommunity community)
        {
            GroupHostManager.EnsureServiceHost(group);

            new ExternalCommunityLinkChangedCoordinator(group)
            {
                ExternalCommunity = community,
                Notification = new ExternalCommunityLinkChangedNotification
                {
                    ChangeType = changeType,
                    Community = community.ToPublicContract(),
                    Group = group.ToNotification(FriendsServiceConfiguration.Instance.GroupsRootUrl),
                }
            }.Enqueue();
        }

        public static void Create(ExternalCommunity community, ExternalCommunityLinkChangeType changeType)
        {
            var groups = Group.MultiGetLocal(community.MappedGroups.Select(id => new KeyInfo(id)));
            Create(community, groups, changeType);
        }

        public static void Create(ExternalCommunity community, IEnumerable<Group> groups, ExternalCommunityLinkChangeType changeType)
        {
            foreach(var group in groups)
            {
                Create(group, changeType, community);
            }
        }
    }
}
