﻿using System.Collections.Generic;
using Curse.CloudQueue;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data.Queues
{
    [CloudQueueProcessor(false)]
    public class ExternalCommunityLinkChangedMultiSessionNotifier : BaseSessionNotification<ExternalCommunityLinkChangedMultiSessionNotifier>
    {
        public ExternalCommunityLinkChangedNotification Notification { get; set; }

        public ExternalCommunityLinkChangedMultiSessionNotifier()
        {
            
        }

        public ExternalCommunityLinkChangedMultiSessionNotifier(HashSet<string> sessionIDs, string serverName, int regionID) : base(sessionIDs, serverName, regionID)
        {
            
        }

        public static void Create(ExternalCommunityLinkChangedNotification notification, HashSet<string> sessionIDs, string serverName, int regionID)
        {
            new ExternalCommunityLinkChangeMultiSessionNotifier(notification,sessionIDs,serverName,regionID).Enqueue();
        }
    }

    public class ExternalCommunityLinkChangeMultiSessionNotifier : BaseMultiSessionNotifier<ExternalCommunityLinkChangedNotification>
    {
        public ExternalCommunityLinkChangeMultiSessionNotifier(ExternalCommunityLinkChangedNotification notification, HashSet<string> sessionIDs, string serverName, int regionID)
            : base(notification, sessionIDs, serverName, regionID)
        {
        }
    }
}
