﻿using System;
using System.Collections.Generic;
using System.Linq;
using Curse.Aerospike;
using Curse.CloudQueue;
using Curse.Extensions;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    [CloudQueue(true)]
    [CloudQueueProcessor(true)]
    public class ExternalCommunityMemberSyncWorker : BaseCloudQueueShoveledMessage<ExternalCommunityMemberSyncWorker>
    {
        public string ExternalCommunityID { get; set; }

        public AccountType AccountType { get; set; }

        public GroupRoleTag? RoleFilter { get; set; }

        public ExternalCommunityMemberSyncWorker()
        {
            
        }

        private ExternalCommunityMemberSyncWorker(int regionID) : base(regionID)
        {
            
        }

        public static void Create(int regionID, string externalCommunityID, AccountType accountType, GroupRoleTag? roleFilter=null)
        {
            new ExternalCommunityMemberSyncWorker(regionID > 0 ? regionID : QueueConfiguration.LocalRegionID)
            {
                ExternalCommunityID = externalCommunityID,
                AccountType = accountType,
                RoleFilter = roleFilter,
            }.Enqueue();
        }        
    }
}
