﻿using System.Collections.Generic;
using System.Linq;
using Curse.CloudQueue;
using Curse.Friends.Data.DerivedModels;

namespace Curse.Friends.Data.Queues
{
    public enum ExternalGuildCoordinatorType
    {
        Commission,
        Decommission,
        Transfer
    }

    [CloudQueueProcessor(true)]
    public class ExternalGuildCoordinator : BaseCloudQueueRoutedMessage<ExternalGuildCoordinator>
    {
        public ExternalGuildCoordinatorType Type { get; set; }

        public ExternalGuildIdentifier[] GuildIdentifiers { get; set; }

        public ExternalGuildCoordinator()
        {
            
        }

        private ExternalGuildCoordinator(ExternalGuild guild)
        {
            guild.EnsureHost();
            DestinationRegionID = guild.RegionID;
            DestinationServerName = guild.MachineName;
            GuildIdentifiers = new[] {guild.GetGuildInfo()};
        }

        public static void CommissionGuild(ExternalGuild guild)
        {
            new ExternalGuildCoordinator(guild)
            {
                Type = ExternalGuildCoordinatorType.Commission,
            }.Enqueue();
        }

        public static void DecommissionGuild(ExternalGuild guild)
        {
            new ExternalGuildCoordinator(guild)
            {
                Type = ExternalGuildCoordinatorType.Decommission,
            }.Enqueue();
        }

        public static void TransferGuilds(int destinationRegionID, string destinationMachineName, IEnumerable<ExternalGuildIdentifier> guilds)
        {
            new ExternalGuildCoordinator
            {
                DestinationRegionID = destinationRegionID,
                DestinationServerName = destinationMachineName,
                Type = ExternalGuildCoordinatorType.Transfer,
                GuildIdentifiers = guilds.ToArray()
            }.Enqueue();
        }
    }
}
