﻿using System;
using Curse.Friends.Data.Messaging;
using Curse.Friends.Enums;

namespace Curse.Friends.Data.Queues
{
    public class ExternalMessageCoordinator : BaseGroupEndpointNotification<ExternalMessageCoordinator>
    {
        // Channel Info
        public string ExternalChannelID { get; set; }

        // User Info
        public int[] MappedUserIDs { get; set; }
        public string ExternalUserID { get; set; }
        public string ExternalUsername { get; set; }
        public string ExternalUserDisplayName { get; set; }
        public string ExternalUserColor { get; set; }
        public ConversationMessageBadge[] Badges { get; set; }

        // Message Info
        public Guid MessageID { get; set; }
        public string MessageBody { get; set; }
        public DateTime MessageTimestamp { get; set; }
        public int BitsUsed { get; set; }
        public ConversationMessageEmoteSubstitution[] EmoteSubstitutions { get; set; }


        public ExternalMessageCoordinator()
        {
            
        }

        private ExternalMessageCoordinator(Group rootGroup) : base(rootGroup)
        {
            
        }

        public static void Create(Group rootGroup, string externalChannelID, int[] mappedUserIDs, 
            string externalUserID, string externalUsername, string externalUserDisplayName, string externalUserColor, ConversationMessageBadge[] badges,
            Guid messageID, string messageBody, DateTime messageTimestamp, ConversationMessageEmoteSubstitution[] messageEmoteSubstitutions, int bitsUsed)
        {
            GroupHostManager.EnsureServiceHost(rootGroup);

            new ExternalMessageCoordinator(rootGroup)
            {
                ExternalChannelID = externalChannelID,
                MappedUserIDs = mappedUserIDs,
                ExternalUserID = externalUserID,
                ExternalUsername = externalUsername,
                ExternalUserDisplayName = externalUserDisplayName,
                ExternalUserColor = externalUserColor,
                Badges = badges,
                MessageID = messageID,
                MessageBody = messageBody,
                MessageTimestamp = messageTimestamp,
                EmoteSubstitutions = messageEmoteSubstitutions,
                BitsUsed = bitsUsed,
            }.Enqueue();
        }
    }
}
