﻿using System;
using Curse.CloudQueue;

namespace Curse.Friends.Data
{
    public class ExternalMessageResolver : BaseCloudQueueRoutedMessage<ExternalMessageResolver>
    {
        public ClientEndpoint RequestorEndpoint { get; set; }

        public string MessageBody { get; set; }

        public ExternalAccount RequestorAccount { get; set; }

        public ExternalCommunity Community { get; set; }

        public Guid ClientMessageID { get; set; }

        public string ConversationID { get; set; }

        public ExternalMessageResolver()
        {
            
        }

        private ExternalMessageResolver(ExternalAccount account) : base(account.MachineName, account.RegionID)
        {
            RequestorAccount = account;
        }

        public static void Create(ExternalAccount account, ExternalCommunity community, ClientEndpoint senderEndpoint, string message, Guid clientMessageID, string conversationID)
        {
            if (account.RegionID == 0)
            {
                account.RegionID = ExternalAccount.LocalConfigID;
            }

            TwitchChatHostManager.EnsureServiceHost(account);
            new ExternalMessageResolver(account)
            {
                Community = community,
                RequestorEndpoint = senderEndpoint,
                MessageBody = message,
                ClientMessageID = clientMessageID,
                ConversationID = conversationID,
            }.Enqueue();
        }
    }
}
