﻿using System;
using Curse.CloudQueue;
using Curse.Friends.Data.Messaging;

namespace Curse.Friends.Data.Queues
{
    [CloudQueueProcessor(4, true)]
    public class ExternalPrivateMessageWorker : BaseCloudQueueWorkerMessage<ExternalPrivateMessageWorker>
    {
        public int SenderID { get; set; }
        public string SenderIpAddress { get; set; }
        public string ConversationID { get; set; }
        public string Body { get; set; }
        public Guid MessageID { get; set; }
        public DateTime MessageTimestamp { get; set; }
        public ConversationMessageEmoteSubstitution[] EmoteOverrides { get; set; }
        
        public static void Create(int senderID, string senderIpAddress, string conversationID, string body, Guid messageID, DateTime messageTimestamp, ConversationMessageEmoteSubstitution[] emoteOverrides = null)
        {
            new ExternalPrivateMessageWorker
            {
                SenderID = senderID,                
                SenderIpAddress = senderIpAddress,
                ConversationID = conversationID,
                Body = body,
                MessageID = messageID,
                MessageTimestamp = messageTimestamp,                
                EmoteOverrides = emoteOverrides,
            }.Enqueue();
        }
    }
}
