﻿using Curse.CloudQueue;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    [CloudQueue(true)]
    [CloudQueueProcessor(true)]
    public class ExternalUserSyncWorker : BaseCloudQueueWorkerMessage<ExternalUserSyncWorker>
    {
        public int CurseUserID { get; set; }

        public string ExternalUserID { get; set; }

        public AccountType AccountType { get; set; }

        public GroupRoleTag? RoleFilter { get; set; }

        public static void Create(int userID, string externalID, AccountType accountType, GroupRoleTag? roleFilter = null)
        {
            new ExternalUserSyncWorker
            {
                ExternalUserID = externalID,
                AccountType = accountType,
                CurseUserID = userID,
                RoleFilter = roleFilter
            }.Enqueue();
        }        
    }
}
