﻿using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data.Queues
{
    public class FriendMessageNotifier : BaseClientEndpointNotification<FriendMessageNotifier>
    {
        public FriendMessageNotifier() { }

        public FriendMessageNotifier(ClientEndpoint endpoint): base(endpoint)
        {

        }
        
        public static void Create(ClientEndpoint endpoint, ConversationMessageNotification notification)
        {
            new FriendMessageTargetedNotifier(notification,endpoint).Enqueue();
        }

        public ConversationMessageNotification Notification { get; set; }
    }

    public class FriendMessageTargetedNotifier : BaseTargetedNotifier<ConversationMessageNotification>
    {
        public FriendMessageTargetedNotifier(ConversationMessageNotification notification, ClientEndpoint endpoint) : base(notification, endpoint)
        {
            
        }
    }
}
