﻿using Curse.Friends.Data.Queues;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    /// <summary>
    /// Notifies a connected client that one of their friends have changed.
    /// </summary>    
    public class FriendshipChangeNotifier : BaseTargetedNotifier<FriendshipChangeNotification>
    {
        public FriendshipChangeNotifier(FriendshipChangeNotification notification, ClientEndpoint endpoint) : base(notification, endpoint)
        {
        }

        public static void Create(ClientEndpoint endpoint, FriendshipContract friendshipContract)
        {
            var contract = new FriendshipChangeNotification { Friendship = friendshipContract };
            new FriendshipChangeNotifier(contract, endpoint).Enqueue();
        }
    }
}
