﻿using Curse.Friends.Data.Queues;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    public class FriendshipRemovedNotifier : BaseTargetedNotifier<FriendshipRemovedNotification>
    {
        public FriendshipRemovedNotifier(FriendshipRemovedNotification notification, ClientEndpoint endpoint) : base(notification, endpoint)
        {
        }

        public static void Create(ClientEndpoint endpoint, int friendID)
        {
            var notification = new FriendshipRemovedNotification { FriendID = friendID };
            new FriendshipRemovedNotifier(notification, endpoint).Enqueue();
        }
    }
    
}
