﻿using Curse.CloudQueue;
using Curse.Friends.Enums;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Friends.Data
{
    public class FriendshipRemovedResolver : BaseCloudQueueWorkerMessage<FriendshipRemovedResolver>
    {
        /// <summary>
        /// The ID of the receiving user
        /// </summary>
        public int UserID
        {
            get;
            set;
        }

        /// <summary>
        /// The ID of the sending user
        /// </summary>
        public int FriendID
        {
            get;
            set;
        }        

        public static void StartProcessor()
        {
            StartProcessor(QueueProcessor_ProcessMessage);
        }

        static void QueueProcessor_ProcessMessage(FriendshipRemovedResolver e)
        {            
            var userEndpoints = ClientEndpoint.GetAllConnected(e.UserID);

            foreach(var endpoint in userEndpoints)
            {
                
                // Dispatch a notification for each endpoint
                FriendshipRemovedNotifier.Create(endpoint,e.FriendID);
            }
        }

    }
}
