﻿using System;
using Curse.CloudQueue;
using Curse.Friends.Data.Search;

namespace Curse.Friends.Data
{
    [CloudQueue(true)]
    [CloudQueueProcessor(4, true)]
    public class GroupBannedUserIndexWorker : BaseCloudQueueShoveledMessage<GroupBannedUserIndexWorker>
    {

        public GroupBannedUserSearchModel BannedUser { get; set; }

        public static void Create(GroupBannedUserSearchModel bannedUser)
        {
            new GroupBannedUserIndexWorker
            {
                BannedUser = bannedUser
            }.Enqueue();
        }

        public static void StartProcessor()
        {
            StartProcessor(Process);
        }

        private static void Process(GroupBannedUserIndexWorker worker)
        {
            try
            {
                GroupBannedUserSearchManager.Index(worker.BannedUser);
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to index banned user", new {worker});
            }
        }
    }
}
