﻿using Curse.Friends.NotificationContracts;
using Curse.Logging;
using System;
using Curse.Extensions;
using Curse.Friends.Data.Queues;

namespace Curse.Friends.Data
{
    // Queued from ConversationBulkMessageWorker and processed in GroupWorker.
    public class GroupBulkMessageDeleteCoordinator : BaseGroupEndpointNotification<GroupBulkMessageDeleteCoordinator>
    {
        public int UserID { get; set; }
        public DateTime StartMessageTimestamp { get; set; }
        public DateTime EndMessageTimestamp { get; set; }
        public int DeletingUserID { get; set; }
        public string DeletingUsername { get; set; }

        public GroupBulkMessageDeleteCoordinator()
        { }

        public GroupBulkMessageDeleteCoordinator(Group group) : base(group)
        { }

        public static void Create(Group group, int userID, DateTime startMessageTimestamp, DateTime endMessageTimestamp, int deletingUserID, string deletingUsername)
        {
            try
            {
                GroupHostManager.EnsureServiceHost(group.RootGroup);
                new GroupBulkMessageDeleteCoordinator(group.RootGroup)
                {
                    UserID = userID,
                    StartMessageTimestamp = startMessageTimestamp,
                    EndMessageTimestamp = endMessageTimestamp,
                    DeletingUserID = deletingUserID,
                    DeletingUsername = deletingUsername,
                }.Enqueue();
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to notify group service of bulk message deletion.");
            }
        }

        public GroupBulkMessageDeleteNotification CreateNotification()
        {
            return new GroupBulkMessageDeleteNotification
            {
                GroupID = GroupID,
                UserID = UserID,
                StartMessageTimestamp = StartMessageTimestamp.SafeToEpochMilliseconds(),
                EndMessageTimestamp = EndMessageTimestamp.SafeToEpochMilliseconds(),
                DeletingUserID = DeletingUserID,
                DeletingUserName = DeletingUsername
            };
        }
    }
}
